import { Text } from "@/components/typeography/text";
import { getCurrentUserFromServer } from "@/features/auth/lib/session.amplify";
import { InvitesTableClient } from "@/features/user-management/components/invites.table.client";
import { UsersTableClient } from "@/features/user-management/components/users.table.client";
import { WorkflowDialogClient } from "@/features/user-management/components/workflow.dialog.client";

export const dynamic = 'force-dynamic'

export default async function PortalUserManagement() {
  const [currentUser] = await Promise.all([
    getCurrentUserFromServer(),
  ])

  return (
    <div className="flex flex-col gap-6 lg:gap-14 w-full overflow-hidden rounded-sm">
      <div className="text-pretty grid gap-6 lg:gap-0 lg:grid-cols-[24rem,_1fr] xl:grid-cols-2">
        <div>
          <Text variant={"h4"}>Users</Text>
          <Text variant={"p"} affects={"subtle"} tint={"muted"}>All users listed are available to interact with the preview branch of the trip planner. Only admin users will have access to upload feeds, invite new members, and view performance metrics.</Text>
        </div>

        <UsersTableClient />
      </div>


      <InvitesTableClient />

      <WorkflowDialogClient currentUser={currentUser} />
    </div>
  );
}

